#define SAMP_PLAYER_MAX 102

struct samp_player_info
{
   #pragma pack(1)
   struct actor_info    **actor;    /* 0 - actor pointer */
   struct vehicle_info  **vehicle;  /* 4 - vehicle pointer (NULL if in a vehicle) */
   uint8_t        color_id;         /* 8 - color id */
   uint8_t        __unknown_9;      /* 9 - set this to 1, and the player warps away (wtf) */
   uint8_t        __unknown_10;     /* 10 - set this to 0, and the player dissapears + this entire struct is cleared */
   uint8_t        __unknown_11[13]; /* 11 */
   float          actor_pos[3];     /* 24 - position */
   uint8_t        __unknown_36[38]; /* 36 - (direction, health?) */
   float          vehicle_pos[3];   /* 74 - position */
   float          vehicle_dir[3];   /* 86 - direction vector */
   float          vehicle_health;   /* 98 - health */
   /* more stuff follows */
};

struct samp_player_list
{
   #pragma pack(1)
   uint32_t alloc_map[SAMP_PLAYER_MAX];
   void     *__unknown_samp_ptr; /* probably a player_info struct.. */
   uint8_t  self_id;
   struct samp_player_info *player_info[SAMP_PLAYER_MAX];
   char     self_name[25];
   char     name[SAMP_PLAYER_MAX][25];
   int32_t  self_score;
   int32_t  score[SAMP_PLAYER_MAX];
   uint32_t self_ping;
   uint32_t ping[SAMP_PLAYER_MAX];
};

D3DCOLOR samp_color_get(int id);
struct samp_player_list *samp_player_list_get(void);
int samp_player_count(void);
int samp_players_list(void);
const char *samp_player_name_get(int id);
struct actor_info *samp_player_actor_info_get(int id);
int samp_player_get_id_by_actor(struct actor_info *info);
