#include "main.h"


D3DCOLOR samp_color_get(int id)
{
   static const void *samp_dll = dll_baseptr_get("samp.dll");
   D3DCOLOR *color_table;

   if(samp_dll == NULL || id < 0 || id >= 103)
      return D3DCOLOR_ARGB(0xFF, 0x99, 0x99, 0x99);

   switch(id)
   {
   case 100: return D3DCOLOR_ARGB(0xFF, 0x88, 0x88, 0x88);
   case 101: return D3DCOLOR_ARGB(0xFF, 0x00, 0x00, 0xAA);
   case 102: return D3DCOLOR_ARGB(0xFF, 0x63, 0xC0, 0xE2);
   }

   color_table = (D3DCOLOR *)((uint8_t *)samp_dll + 0x000B1814);

   return (color_table[id] >> 8) | 0xFF000000;
}


/* 021BDA03  |.  8B15 302C2602 mov edx,dword ptr ds:[2262C30]
   021BDA09  |.  8B3A          mov edi,dword ptr ds:[edx]
*/
struct samp_player_list *samp_player_list_get(void)
{
   static const void *samp_dll = dll_baseptr_get("samp.dll");
   uint32_t *ptr;
   uint32_t *edx;
   void     *edi;

   if(samp_dll == NULL)
      return NULL;

   ptr = (uint32_t *)((uint8_t *)samp_dll + 0x00B2C30);
   edx = (uint32_t *)(UINT_PTR)*ptr;
   if(edx == NULL)
      return NULL;
   edi = (void     *)(UINT_PTR)*edx;

   return (struct samp_player_list *)edi;
}


int samp_player_count(void)
{
   struct samp_player_list *spl = samp_player_list_get();
   int count = 0;
   int i;

   if(spl == NULL)
      return 0;

   for(i=0; i<102; i++)
   {
      if(spl->alloc_map[i] != 1)
         continue;

      count++;
   }

   return count + 1;
}


const char *samp_player_name_get(int id)
{
   struct samp_player_list *spl = samp_player_list_get();

   if(spl == NULL || id < 0 || id >= SAMP_PLAYER_MAX)
      return NULL;

   if(id == spl->self_id)
      return spl->self_name;

   if(spl->alloc_map[id] != 1)
      return NULL;

   return spl->name[id];
}


struct actor_info *samp_player_actor_info_get(int id)
{
   struct samp_player_list *spl = samp_player_list_get();

   if(spl == NULL || id < 0 || id >= SAMP_PLAYER_MAX)
      return NULL;

   if(id == spl->self_id)
      return actor_info_get(ACTOR_SELF, 0);

   if(spl->alloc_map[id] != 1)
      return NULL;

   if(spl->player_info[id] == NULL)
      return NULL;

   if(spl->player_info[id]->actor == NULL)
      return NULL;

   return *spl->player_info[id]->actor;
}


int samp_player_get_id_by_actor(struct actor_info *info)
{
   struct samp_player_list *spl = samp_player_list_get();
   int i;

   if(spl == NULL)
      return -1;

   if(actor_info_get(ACTOR_SELF, 0) == info)
      return spl->self_id;

   for(i=0; i<SAMP_PLAYER_MAX; i++)
   {
      if(spl->alloc_map[i] != 1)
         continue;

      if(spl->player_info[i] == NULL ||
         spl->player_info[i]->actor == NULL)
         continue;

      if(*spl->player_info[i]->actor == info)
         return i;
   }

   return -1;
}

