#include "main.h"
#include "proxyIDirect3D9.h"
#include "proxyIDirect3DDevice9.h"
#include "proxyIDirect3DSwapChain9.h"


proxyIDirect3DSwapChain9::proxyIDirect3DSwapChain9(IDirect3DSwapChain9 *pOriginal, IDirect3DDevice9 *pDevice)
{
   log_debug("proxyIDirect3DSwapChain9 constructor called. Original IDirect3DSwapChain9 address is 0x%p.", pDevice);
	origIDirect3DSwapChain9 = pOriginal;
	origIDirect3DDevice9 = pDevice; 
}

proxyIDirect3DSwapChain9::~proxyIDirect3DSwapChain9(void)
{
   log_debug("proxyIDirect3DSwapChain9 destructor called.");
   origIDirect3DSwapChain9 = NULL;
}

HRESULT proxyIDirect3DSwapChain9::QueryInterface (REFIID riid, void** ppvObj)
{
   HRESULT hRes;

   *ppvObj = NULL;
   hRes = origIDirect3DSwapChain9->QueryInterface(riid, ppvObj); 
   if(hRes == NOERROR)
      *ppvObj = this;

   return hRes;
}

ULONG proxyIDirect3DSwapChain9::AddRef(void)
{
	return origIDirect3DSwapChain9->AddRef();
}

ULONG proxyIDirect3DSwapChain9::Release(void)
{
	ULONG count = origIDirect3DSwapChain9->Release();

   if(count == 0)
   {
      pDirect3DSwapChain9 = NULL;
      delete(this);
   }

   return count;
}

HRESULT proxyIDirect3DSwapChain9::Present(CONST RECT *pSourceRect, CONST RECT *pDestRect, HWND hDestWindowOverride, CONST RGNDATA *pDirtyRegion, DWORD dwFlags)
{
   HRESULT hRes;

	hRes = origIDirect3DSwapChain9->Present(pSourceRect, pDestRect, hDestWindowOverride, pDirtyRegion, dwFlags);
    
	return hRes;
}

HRESULT proxyIDirect3DSwapChain9::GetFrontBufferData(IDirect3DSurface9 *pDestSurface)
{
	return origIDirect3DSwapChain9->GetFrontBufferData(pDestSurface);
}

HRESULT proxyIDirect3DSwapChain9::GetBackBuffer(UINT iBackBuffer, D3DBACKBUFFER_TYPE Type, IDirect3DSurface9 **ppBackBuffer)
{
	return origIDirect3DSwapChain9->GetBackBuffer(iBackBuffer, Type, ppBackBuffer);
}

HRESULT proxyIDirect3DSwapChain9::GetRasterStatus(D3DRASTER_STATUS *pRasterStatus)
{
	return origIDirect3DSwapChain9->GetRasterStatus(pRasterStatus);
}

HRESULT proxyIDirect3DSwapChain9::GetDisplayMode(D3DDISPLAYMODE *pMode)
{
	return origIDirect3DSwapChain9->GetDisplayMode(pMode);
}

HRESULT proxyIDirect3DSwapChain9::GetDevice(IDirect3DDevice9 **ppDevice)
{
	return origIDirect3DSwapChain9->GetDevice(ppDevice);
}

HRESULT proxyIDirect3DSwapChain9::GetPresentParameters(D3DPRESENT_PARAMETERS *pPresentationParameters)
{
	return origIDirect3DSwapChain9->GetPresentParameters(pPresentationParameters);
}
