#include "main.h"

struct safe_haven *safe_haven_list = NULL;
int safe_haven_list_size = 0;


void ini_safe_haven_load(void)
{
   void *tmp;
   float x, y, z;
   char filename[512];
   char line[512];
   FILE *fd;
   int len;


   snprintf(filename, sizeof(filename), "%s\\%s", dll_working_dir, "s0biet_hack_safe_haven.ini");

   log_debug("Loading %s...", filename);

   fd = fopen(filename, "r");
   if(fd == NULL)
   {
      log_debug("Could not open %s.", filename);
      return;
   }

   safe_haven_list_size = 0;

   while(fgets(line, sizeof(line), fd) != NULL)
   {
      len = (int)strlen(line);

      /* strip trailing newlines, spaces, and tabs */
      while(len > 0 && strchr("\t\n\r ", line[len - 1]))
         line[--len] = 0;

      /* skip comments and empty lines */
      if(line[0] == '#' || line[0] == ';' || line[0] == 0)
         continue;

      if(sscanf(line, "%f %f %f", &x, &y, &z) != 3)
      {
         log_debug("Parse error: %s", line);
         continue;
      }

      tmp = realloc((void *)safe_haven_list, sizeof(struct safe_haven) * (safe_haven_list_size + 1));
      if(tmp == NULL)
      {
         log_debug("Out of memory :p");
         continue;
      }
      safe_haven_list = (struct safe_haven *)tmp;

      safe_haven_list[safe_haven_list_size].pos[0] = x;
      safe_haven_list[safe_haven_list_size].pos[1] = y;
      safe_haven_list[safe_haven_list_size].pos[2] = z;
      safe_haven_list_size++;
   }

   fclose(fd);


   log_debug("Done.");
}
