#define INI_STRLEN_MAX     64 /* including null */
#define INI_PATCHES_MAX    128

struct settings_coord
{
   float pos[3];
   int   interior_id;
};

struct settings
{
   int key_hp_cheat;
   int key_safe_haven;
   float hp_minimum;
   float hp_damage_reduce;
   float hp_regen;
   int hp_indestructible;
   float hp_safe_haven_warp_below;

   int key_air_break_mod;
   int key_air_break_foot_mod;
   int key_air_break_mod2;
   int key_air_break_forward;
   int key_air_break_backward;
   int key_air_break_left;
   int key_air_break_right;
   int key_air_break_up;
   int key_air_break_down;
   int key_air_break_rot_yaw1;
   int key_air_break_rot_yaw2;
   int key_air_break_rot_roll1;
   int key_air_break_rot_roll2;
   int key_air_break_rot_pitch1;
   int key_air_break_rot_pitch2;
   int air_break_toggle;
   int air_break_behaviour;
   float air_break_speed;
   float air_break_rot_speed;
   float air_break_accel_time;

   int key_warp_mod;
   float warp_speed;
   int warp_use_speed;

   int key_teleport[TELEPORT_MAX];
   int key_teleport_set[TELEPORT_MAX];
   struct settings_coord teleport[TELEPORT_MAX];

   char static_teleport_name[STATIC_TELEPORT_MAX][INI_STRLEN_MAX];
   struct settings_coord static_teleport[STATIC_TELEPORT_MAX];

   int key_unflip;

   int key_stick;
   int key_stick_prev;
   int key_stick_next;
   int key_stick_nearest;
   int key_stick_forward;
   int key_stick_backward;
   int key_stick_left;
   int key_stick_right;
   int key_stick_up;
   int key_stick_down;
   int key_stick_in;
   int key_stick_out;
   float stick_min_height;
   float stick_vect[4];    /* must be 4d! */
   float stick_vect_dist;
   float stick_accel_time;

   int key_checkpoint_1;
   int key_checkpoint_2;
   float checkpoint_min_height;

   int key_nitro_mod;
   float nitro_high;
   float nitro_low;
   float nitro_accel_time;
   float nitro_decel_time;

   int key_protection;
   float protection_spin_cap;
   float protection_min_height;

   int key_self_destruct;

   int key_autoaim;

   int key_map;

   int key_money;
   int money_enabled;
   int money_amount_max;
   int money_amount_rand_min;
   int money_amount_rand_max;
   int money_interval_rand_min;
   int money_interval_rand_max;

   int key_weapon;
   int weapon_enabled;
   struct weapon_entry *weapon[13];

   int key_menu;
   int key_menu_up;
   int key_menu_right;
   int key_menu_down;
   int key_menu_left;
   int key_menu_select;

   int force_hour;
   int force_weather;
   int d3dtext_hud;
   int inchat_disable;
   int window_mode;
   int window_mode_titlebar;
   int blur_remove;
   int old_keyhook;

   int walk_under_water;
   int vehicles_unlock;
   int vehicles_warp_invert;

   struct patch_set patch[INI_PATCHES_MAX];
};

extern struct settings set;

void ini_load(void);
void ini_reload(void);
void ini_free(void);
