struct menu;

#define MENU_SCROLL_SPEED  15    /* auto-scroll speed (scrolls per second) */
#define MENU_SCROLL_DELAY  200   /* delay in milliseconds before auto-scrolling */

#define MENU_SCROLL_TIME   MSEC_TO_TIME(1000 / MENU_SCROLL_SPEED)

#define MENU_OP_ENABLED 0
#define MENU_OP_SELECT  1

#define MENU_COLOR_DEFAULT    D3DCOLOR_XRGB(223, 223, 223)
#define MENU_COLOR_SEPARATOR  D3DCOLOR_XRGB(157, 157, 157)

struct menu_item
{
   struct menu *submenu;
   struct menu *menu;
   const char  *name;
   int         id;
   D3DCOLOR    color;
   void        *data;
   int         enabled; /* not necessarily used */
};

typedef int (*menu_callback)(int op, struct menu_item *);

struct menu
{
   struct menu       *parent;
   int               id;
   int               count;
   int               pos;
   int               top_pos;
   struct menu_item  *item;
   menu_callback     callback;
};

void menu_run(void);
void menu_maybe_init(void);
void menu_items_free(struct menu *menu);
void menu_free_all(void);

extern struct menu *menu_active;
