#define VEHICLE_LIST_ID_START 400
#define VEHICLE_LIST_SIZE     212

#define VEHICLE_CLASS_CAR        0
#define VEHICLE_CLASS_CAR_FAST   1
#define VEHICLE_CLASS_HEAVY      2
#define VEHICLE_CLASS_HELI       3
#define VEHICLE_CLASS_AIRPLANE   4
#define VEHICLE_CLASS_BIKE       5
#define VEHICLE_CLASS_BOAT       6
#define VEHICLE_CLASS_MINI       7
#define VEHICLE_CLASS_COUNT      8  /* # of classes */

#define ACTOR_IS_DEAD(a) ((a)->state == ACTOR_STATE_DYING || (a)->state == ACTOR_STATE_DEAD)

#define ACTOR_ALIVE              0x01
#define ACTOR_NOT_SAME_VEHICLE   0x02

#define VEHICLE_ALIVE            0x01
#define VEHICLE_EMPTY            0x02

struct weapon_entry
{
   int id;
   int slot;
   int model_id;
   const char *name;
};

struct vehicle_entry
{
   int id;
   int class_id;
   const char *name;
};

struct str_split
{
   char  *str;
   char  **argv;
   int   argc;
};



void gta_weather_state_set(int state);
void gta_time_hour_set(int hour);

void gta_money_set(uint32_t amount);
uint32_t gta_money_get(void);

struct checkpoint *gta_checkpoint_info_get(int n);

int gta_menu_active(void);
void gta_menu_active_set(int enabled);

const struct weapon_entry *gta_weapon_get_by_name(const char *name);
void gta_weapon_set(struct actor_info *info, int slot, int id, int ammo, int ammo_clip);
int gta_weapon_ammo_set(struct actor_info *info, int slot, int ammo);
int gta_weapon_ammo_clip_set(struct actor_info *info, int slot, int ammo_clip);

const char *gta_vehicle_class_name(int id);
const struct vehicle_entry *gta_vehicle_get_by_id(int id);

void gta_model_request(int model_id);
void gta_vehicle_spawn(int vehicle_id);
void gta_jetpack_give(void);
int gta_interior_id_get(void);
void gta_interior_id_set(int id);

uint32_t __time_get(void);
void cheat_state_text(const char *fmt, ...);
struct actor_info *actor_info_get(int id, int flags);
struct vehicle_info *vehicle_info_get(int id, int flags);

void vehicle_detachables_teleport(struct vehicle_info *info, const float from[3], const float to[3]);
void vehicle_state_store(const struct vehicle_info *info, struct vehicle_state *state);
void vehicle_state_restore(struct vehicle_info *info, const struct vehicle_state *state);

void vehicle_prevent_below_height(struct vehicle_info *info, float height);

int vehicle_find(int id, int dir, int flags);
int actor_find(int id, int dir, int flags);
int vehicle_find_nearest(int flags);
int actor_find_nearest(int flags);

struct vehicle_info *actor_vehicle_get(const struct actor_info *info);

const float *safe_haven_nearest_pos_get(float pos[3]);

int memcpy_safe(void *dest, const void *src, uint32_t len);
int memset_safe(void *_dest, int c, uint32_t len);
int memcmp_safe(const void *_s1, const void *_s2, uint32_t len);

void *dll_baseptr_get(const char *dll_name);

void str_split_free(struct str_split *split);
struct str_split *str_split(const char *str, const char *ch);

size_t strlcpy(char *dst, const char *src, size_t size);
size_t strlcat(char *dst, const char *src, size_t size);

void *memdup(const void *src, int len);
uint8_t *hex_to_bin(const char *str);

extern const struct weapon_entry weapon_list[];
extern const struct vehicle_entry vehicle_list[VEHICLE_LIST_SIZE];
